package io.burkard.cdk.services.opensearchservice

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsOptions {

  def apply(
    enabled: Option[Boolean] = None,
    iops: Option[Number] = None,
    volumeSize: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.opensearchservice.EbsOptions =
    (new software.amazon.awscdk.services.opensearchservice.EbsOptions.Builder)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .iops(iops.orNull)
      .volumeSize(volumeSize.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
