package io.burkard.cdk.services.nimblestudio

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStudioProps {

  def apply(
    displayName: String,
    studioName: String,
    adminRoleArn: String,
    userRoleArn: String,
    studioEncryptionConfiguration: Option[software.amazon.awscdk.services.nimblestudio.CfnStudio.StudioEncryptionConfigurationProperty] = None,
    tags: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnStudioProps =
    (new software.amazon.awscdk.services.nimblestudio.CfnStudioProps.Builder)
      .displayName(displayName)
      .studioName(studioName)
      .adminRoleArn(adminRoleArn)
      .userRoleArn(userRoleArn)
      .studioEncryptionConfiguration(studioEncryptionConfiguration.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
