package io.burkard.cdk.services.nimblestudio

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ActiveDirectoryConfigurationProperty {

  def apply(
    computerAttributes: Option[List[_]] = None,
    organizationalUnitDistinguishedName: Option[String] = None,
    directoryId: Option[String] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnStudioComponent.ActiveDirectoryConfigurationProperty =
    (new software.amazon.awscdk.services.nimblestudio.CfnStudioComponent.ActiveDirectoryConfigurationProperty.Builder)
      .computerAttributes(computerAttributes.map(_.asJava).orNull)
      .organizationalUnitDistinguishedName(organizationalUnitDistinguishedName.orNull)
      .directoryId(directoryId.orNull)
      .build()
}
