package io.burkard.cdk.services.networkfirewall

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StatefulRuleProperty {

  def apply(
    action: String,
    header: software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.HeaderProperty,
    ruleOptions: List[_]
  ): software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.StatefulRuleProperty =
    (new software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.StatefulRuleProperty.Builder)
      .action(action)
      .header(header)
      .ruleOptions(ruleOptions.asJava)
      .build()
}
