package io.burkard.cdk.services.msk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BrokerLogsProperty {

  def apply(
    firehose: Option[software.amazon.awscdk.services.msk.CfnCluster.FirehoseProperty] = None,
    cloudWatchLogs: Option[software.amazon.awscdk.services.msk.CfnCluster.CloudWatchLogsProperty] = None,
    s3: Option[software.amazon.awscdk.services.msk.CfnCluster.S3Property] = None
  ): software.amazon.awscdk.services.msk.CfnCluster.BrokerLogsProperty =
    (new software.amazon.awscdk.services.msk.CfnCluster.BrokerLogsProperty.Builder)
      .firehose(firehose.orNull)
      .cloudWatchLogs(cloudWatchLogs.orNull)
      .s3(s3.orNull)
      .build()
}
