package io.burkard.cdk.services.mediapackage

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StreamSelectionProperty {

  def apply(
    streamOrder: Option[String] = None,
    maxVideoBitsPerSecond: Option[Number] = None,
    minVideoBitsPerSecond: Option[Number] = None
  ): software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty =
    (new software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty.Builder)
      .streamOrder(streamOrder.orNull)
      .maxVideoBitsPerSecond(maxVideoBitsPerSecond.orNull)
      .minVideoBitsPerSecond(minVideoBitsPerSecond.orNull)
      .build()
}
