package io.burkard.cdk.services.mediapackage

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CmafEncryptionProperty {

  def apply(
    spekeKeyProvider: software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.SpekeKeyProviderProperty,
    constantInitializationVector: Option[String] = None,
    keyRotationIntervalSeconds: Option[Number] = None
  ): software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.CmafEncryptionProperty =
    (new software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.CmafEncryptionProperty.Builder)
      .spekeKeyProvider(spekeKeyProvider)
      .constantInitializationVector(constantInitializationVector.orNull)
      .keyRotationIntervalSeconds(keyRotationIntervalSeconds.orNull)
      .build()
}
