package io.burkard.cdk.services.medialive

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InputSettingsProperty {

  def apply(
    sourceEndBehavior: Option[String] = None,
    audioSelectors: Option[List[_]] = None,
    networkInputSettings: Option[software.amazon.awscdk.services.medialive.CfnChannel.NetworkInputSettingsProperty] = None,
    videoSelector: Option[software.amazon.awscdk.services.medialive.CfnChannel.VideoSelectorProperty] = None,
    smpte2038DataPreference: Option[String] = None,
    deblockFilter: Option[String] = None,
    filterStrength: Option[Number] = None,
    inputFilter: Option[String] = None,
    denoiseFilter: Option[String] = None,
    captionSelectors: Option[List[_]] = None
  ): software.amazon.awscdk.services.medialive.CfnChannel.InputSettingsProperty =
    (new software.amazon.awscdk.services.medialive.CfnChannel.InputSettingsProperty.Builder)
      .sourceEndBehavior(sourceEndBehavior.orNull)
      .audioSelectors(audioSelectors.map(_.asJava).orNull)
      .networkInputSettings(networkInputSettings.orNull)
      .videoSelector(videoSelector.orNull)
      .smpte2038DataPreference(smpte2038DataPreference.orNull)
      .deblockFilter(deblockFilter.orNull)
      .filterStrength(filterStrength.orNull)
      .inputFilter(inputFilter.orNull)
      .denoiseFilter(denoiseFilter.orNull)
      .captionSelectors(captionSelectors.map(_.asJava).orNull)
      .build()
}
