package io.burkard.cdk.services.medialive

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OutputGroupProperty {

  def apply(
    name: Option[String] = None,
    outputGroupSettings: Option[software.amazon.awscdk.services.medialive.CfnChannel.OutputGroupSettingsProperty] = None,
    outputs: Option[List[_]] = None
  ): software.amazon.awscdk.services.medialive.CfnChannel.OutputGroupProperty =
    (new software.amazon.awscdk.services.medialive.CfnChannel.OutputGroupProperty.Builder)
      .name(name.orNull)
      .outputGroupSettings(outputGroupSettings.orNull)
      .outputs(outputs.map(_.asJava).orNull)
      .build()
}
