package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogGroupProps {

  def apply(
    retention: Option[software.amazon.awscdk.services.logs.RetentionDays] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    logGroupName: Option[String] = None
  ): software.amazon.awscdk.services.logs.LogGroupProps =
    (new software.amazon.awscdk.services.logs.LogGroupProps.Builder)
      .retention(retention.orNull)
      .removalPolicy(removalPolicy.orNull)
      .encryptionKey(encryptionKey.orNull)
      .logGroupName(logGroupName.orNull)
      .build()
}
