package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricTransformationProperty {

  def apply(
    metricValue: String,
    metricName: String,
    metricNamespace: String,
    defaultValue: Option[Number] = None
  ): software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty =
    (new software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty.Builder)
      .metricValue(metricValue)
      .metricName(metricName)
      .metricNamespace(metricNamespace)
      .defaultValue(defaultValue.orNull)
      .build()
}
