package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogGroup {

  def apply(
    internalResourceId: String,
    retention: Option[software.amazon.awscdk.services.logs.RetentionDays] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    logGroupName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.logs.LogGroup =
    software.amazon.awscdk.services.logs.LogGroup.Builder
      .create(stackCtx, internalResourceId)
      .retention(retention.orNull)
      .removalPolicy(removalPolicy.orNull)
      .encryptionKey(encryptionKey.orNull)
      .logGroupName(logGroupName.orNull)
      .build()
}
