package io.burkard.cdk.services.lex

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SlotProperty {

  def apply(
    name: String,
    slotTypeName: String,
    valueElicitationSetting: software.amazon.awscdk.services.lex.CfnBot.SlotValueElicitationSettingProperty,
    description: Option[String] = None,
    multipleValuesSetting: Option[software.amazon.awscdk.services.lex.CfnBot.MultipleValuesSettingProperty] = None,
    obfuscationSetting: Option[software.amazon.awscdk.services.lex.CfnBot.ObfuscationSettingProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBot.SlotProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.SlotProperty.Builder)
      .name(name)
      .slotTypeName(slotTypeName)
      .valueElicitationSetting(valueElicitationSetting)
      .description(description.orNull)
      .multipleValuesSetting(multipleValuesSetting.orNull)
      .obfuscationSetting(obfuscationSetting.orNull)
      .build()
}
