package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object IntentProperty {

  def apply(
    name: String,
    dialogCodeHook: Option[software.amazon.awscdk.services.lex.CfnBot.DialogCodeHookSettingProperty] = None,
    outputContexts: Option[List[_]] = None,
    description: Option[String] = None,
    inputContexts: Option[List[_]] = None,
    intentClosingSetting: Option[software.amazon.awscdk.services.lex.CfnBot.IntentClosingSettingProperty] = None,
    kendraConfiguration: Option[software.amazon.awscdk.services.lex.CfnBot.KendraConfigurationProperty] = None,
    slotPriorities: Option[List[_]] = None,
    parentIntentSignature: Option[String] = None,
    sampleUtterances: Option[List[_]] = None,
    intentConfirmationSetting: Option[software.amazon.awscdk.services.lex.CfnBot.IntentConfirmationSettingProperty] = None,
    slots: Option[List[_]] = None,
    fulfillmentCodeHook: Option[software.amazon.awscdk.services.lex.CfnBot.FulfillmentCodeHookSettingProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBot.IntentProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.IntentProperty.Builder)
      .name(name)
      .dialogCodeHook(dialogCodeHook.orNull)
      .outputContexts(outputContexts.map(_.asJava).orNull)
      .description(description.orNull)
      .inputContexts(inputContexts.map(_.asJava).orNull)
      .intentClosingSetting(intentClosingSetting.orNull)
      .kendraConfiguration(kendraConfiguration.orNull)
      .slotPriorities(slotPriorities.map(_.asJava).orNull)
      .parentIntentSignature(parentIntentSignature.orNull)
      .sampleUtterances(sampleUtterances.map(_.asJava).orNull)
      .intentConfirmationSetting(intentConfirmationSetting.orNull)
      .slots(slots.map(_.asJava).orNull)
      .fulfillmentCodeHook(fulfillmentCodeHook.orNull)
      .build()
}
