package io.burkard.cdk.services.lex

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object IntentClosingSettingProperty {

  def apply(
    closingResponse: software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty,
    isActive: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.IntentClosingSettingProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.IntentClosingSettingProperty.Builder)
      .closingResponse(closingResponse)
      .isActive(isActive.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
