package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ImageResponseCardProperty {

  def apply(
    title: String,
    imageUrl: Option[String] = None,
    subtitle: Option[String] = None,
    buttons: Option[List[_]] = None
  ): software.amazon.awscdk.services.lex.CfnBot.ImageResponseCardProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.ImageResponseCardProperty.Builder)
      .title(title)
      .imageUrl(imageUrl.orNull)
      .subtitle(subtitle.orNull)
      .buttons(buttons.map(_.asJava).orNull)
      .build()
}
