package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SqsEventSource {

  def apply(
    queue: software.amazon.awscdk.services.sqs.IQueue,
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    reportBatchItemFailures: Option[Boolean] = None
  ): software.amazon.awscdk.services.lambda.eventsources.SqsEventSource =
    software.amazon.awscdk.services.lambda.eventsources.SqsEventSource.Builder
      .create(queue)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .batchSize(batchSize.orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .reportBatchItemFailures(reportBatchItemFailures.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
