package io.burkard.cdk.services.lambda

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SnsEventSourceProps {

  def apply(
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps.Builder)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
