package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LayerVersionOptions {

  def apply(
    description: Option[String] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    layerVersionName: Option[String] = None,
    license: Option[String] = None
  ): software.amazon.awscdk.services.lambda.LayerVersionOptions =
    (new software.amazon.awscdk.services.lambda.LayerVersionOptions.Builder)
      .description(description.orNull)
      .removalPolicy(removalPolicy.orNull)
      .layerVersionName(layerVersionName.orNull)
      .license(license.orNull)
      .build()
}
