package io.burkard.cdk.services.lakeformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResource {

  def apply(
    internalResourceId: String,
    useServiceLinkedRole: Boolean,
    resourceArn: String,
    roleArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lakeformation.CfnResource =
    software.amazon.awscdk.services.lakeformation.CfnResource.Builder
      .create(stackCtx, internalResourceId)
      .useServiceLinkedRole(useServiceLinkedRole)
      .resourceArn(resourceArn)
      .roleArn(roleArn.orNull)
      .build()
}
