package io.burkard.cdk.services.kinesisfirehose

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CopyCommandProperty {

  def apply(
    dataTableName: String,
    copyOptions: Option[String] = None,
    dataTableColumns: Option[String] = None
  ): software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CopyCommandProperty =
    (new software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CopyCommandProperty.Builder)
      .dataTableName(dataTableName)
      .copyOptions(copyOptions.orNull)
      .dataTableColumns(dataTableColumns.orNull)
      .build()
}
