package io.burkard.cdk.services.kinesisanalytics

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationProps {

  def apply(
    inputs: List[_],
    applicationCode: Option[String] = None,
    applicationDescription: Option[String] = None,
    applicationName: Option[String] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps.Builder)
      .inputs(inputs.asJava)
      .applicationCode(applicationCode.orNull)
      .applicationDescription(applicationDescription.orNull)
      .applicationName(applicationName.orNull)
      .build()
}
