package io.burkard.cdk.services.kinesisanalytics

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MonitoringConfigurationProperty {

  def apply(
    configurationType: String,
    logLevel: Option[String] = None,
    metricsLevel: Option[String] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MonitoringConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MonitoringConfigurationProperty.Builder)
      .configurationType(configurationType)
      .logLevel(logLevel.orNull)
      .metricsLevel(metricsLevel.orNull)
      .build()
}
