package io.burkard.cdk.services.iotsitewise

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGateway {

  def apply(
    internalResourceId: String,
    gatewayName: String,
    gatewayPlatform: software.amazon.awscdk.services.iotsitewise.CfnGateway.GatewayPlatformProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    gatewayCapabilitySummaries: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iotsitewise.CfnGateway =
    software.amazon.awscdk.services.iotsitewise.CfnGateway.Builder
      .create(stackCtx, internalResourceId)
      .gatewayName(gatewayName)
      .gatewayPlatform(gatewayPlatform)
      .tags(tags.map(_.asJava).orNull)
      .gatewayCapabilitySummaries(gatewayCapabilitySummaries.map(_.asJava).orNull)
      .build()
}
