package io.burkard.cdk.services.iotevents

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StateProperty {

  def apply(
    stateName: String,
    onExit: Option[software.amazon.awscdk.services.iotevents.CfnDetectorModel.OnExitProperty] = None,
    onEnter: Option[software.amazon.awscdk.services.iotevents.CfnDetectorModel.OnEnterProperty] = None,
    onInput: Option[software.amazon.awscdk.services.iotevents.CfnDetectorModel.OnInputProperty] = None
  ): software.amazon.awscdk.services.iotevents.CfnDetectorModel.StateProperty =
    (new software.amazon.awscdk.services.iotevents.CfnDetectorModel.StateProperty.Builder)
      .stateName(stateName)
      .onExit(onExit.orNull)
      .onEnter(onEnter.orNull)
      .onInput(onInput.orNull)
      .build()
}
