package io.burkard.cdk.services.iotanalytics

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3DestinationConfigurationProperty {

  def apply(
    key: String,
    roleArn: String,
    bucket: String,
    glueConfiguration: Option[software.amazon.awscdk.services.iotanalytics.CfnDataset.GlueConfigurationProperty] = None
  ): software.amazon.awscdk.services.iotanalytics.CfnDataset.S3DestinationConfigurationProperty =
    (new software.amazon.awscdk.services.iotanalytics.CfnDataset.S3DestinationConfigurationProperty.Builder)
      .key(key)
      .roleArn(roleArn)
      .bucket(bucket)
      .glueConfiguration(glueConfiguration.orNull)
      .build()
}
