package io.burkard.cdk.services.iotanalytics

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DatastoreStorageProperty {

  def apply(
    serviceManagedS3: Option[software.amazon.awscdk.services.iotanalytics.CfnDatastore.ServiceManagedS3Property] = None,
    customerManagedS3: Option[software.amazon.awscdk.services.iotanalytics.CfnDatastore.CustomerManagedS3Property] = None,
    iotSiteWiseMultiLayerStorage: Option[software.amazon.awscdk.services.iotanalytics.CfnDatastore.IotSiteWiseMultiLayerStorageProperty] = None
  ): software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastoreStorageProperty =
    (new software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastoreStorageProperty.Builder)
      .serviceManagedS3(serviceManagedS3.orNull)
      .customerManagedS3(customerManagedS3.orNull)
      .iotSiteWiseMultiLayerStorage(iotSiteWiseMultiLayerStorage.orNull)
      .build()
}
