package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TopicRulePayloadProperty {

  def apply(
    sql: String,
    actions: List[_],
    awsIotSqlVersion: Option[String] = None,
    ruleDisabled: Option[Boolean] = None,
    description: Option[String] = None,
    errorAction: Option[software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty] = None
  ): software.amazon.awscdk.services.iot.CfnTopicRule.TopicRulePayloadProperty =
    (new software.amazon.awscdk.services.iot.CfnTopicRule.TopicRulePayloadProperty.Builder)
      .sql(sql)
      .actions(actions.asJava)
      .awsIotSqlVersion(awsIotSqlVersion.orNull)
      .ruleDisabled(ruleDisabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .description(description.orNull)
      .errorAction(errorAction.orNull)
      .build()
}
