package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpActionProperty {

  def apply(
    url: String,
    auth: Option[software.amazon.awscdk.services.iot.CfnTopicRule.HttpAuthorizationProperty] = None,
    headers: Option[List[_]] = None,
    confirmationUrl: Option[String] = None
  ): software.amazon.awscdk.services.iot.CfnTopicRule.HttpActionProperty =
    (new software.amazon.awscdk.services.iot.CfnTopicRule.HttpActionProperty.Builder)
      .url(url)
      .auth(auth.orNull)
      .headers(headers.map(_.asJava).orNull)
      .confirmationUrl(confirmationUrl.orNull)
      .build()
}
