package io.burkard.cdk.services.imagebuilder

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ImageTestsConfigurationProperty {

  def apply(
    timeoutMinutes: Option[Number] = None,
    imageTestsEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.imagebuilder.CfnImage.ImageTestsConfigurationProperty =
    (new software.amazon.awscdk.services.imagebuilder.CfnImage.ImageTestsConfigurationProperty.Builder)
      .timeoutMinutes(timeoutMinutes.orNull)
      .imageTestsEnabled(imageTestsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
