package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRoleProps {

  def apply(
    assumeRolePolicyDocument: AnyRef,
    maxSessionDuration: Option[Number] = None,
    path: Option[String] = None,
    permissionsBoundary: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    roleName: Option[String] = None,
    managedPolicyArns: Option[List[String]] = None,
    policies: Option[List[_]] = None
  ): software.amazon.awscdk.services.iam.CfnRoleProps =
    (new software.amazon.awscdk.services.iam.CfnRoleProps.Builder)
      .assumeRolePolicyDocument(assumeRolePolicyDocument)
      .maxSessionDuration(maxSessionDuration.orNull)
      .path(path.orNull)
      .permissionsBoundary(permissionsBoundary.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .roleName(roleName.orNull)
      .managedPolicyArns(managedPolicyArns.map(_.asJava).orNull)
      .policies(policies.map(_.asJava).orNull)
      .build()
}
