package io.burkard.cdk.services.groundstation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AntennaUplinkConfigProperty {

  def apply(
    targetEirp: Option[software.amazon.awscdk.services.groundstation.CfnConfig.EirpProperty] = None,
    transmitDisabled: Option[Boolean] = None,
    spectrumConfig: Option[software.amazon.awscdk.services.groundstation.CfnConfig.UplinkSpectrumConfigProperty] = None
  ): software.amazon.awscdk.services.groundstation.CfnConfig.AntennaUplinkConfigProperty =
    (new software.amazon.awscdk.services.groundstation.CfnConfig.AntennaUplinkConfigProperty.Builder)
      .targetEirp(targetEirp.orNull)
      .transmitDisabled(transmitDisabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .spectrumConfig(spectrumConfig.orNull)
      .build()
}
