package io.burkard.cdk.services.greengrass

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CoreProperty {

  def apply(
    id: String,
    thingArn: String,
    certificateArn: String,
    syncShadow: Option[Boolean] = None
  ): software.amazon.awscdk.services.greengrass.CfnCoreDefinition.CoreProperty =
    (new software.amazon.awscdk.services.greengrass.CfnCoreDefinition.CoreProperty.Builder)
      .id(id)
      .thingArn(thingArn)
      .certificateArn(certificateArn)
      .syncShadow(syncShadow.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
