package io.burkard.cdk.services.glue

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GlueTablesProperty {

  def apply(
    databaseName: String,
    tableName: String,
    connectionName: Option[String] = None,
    catalogId: Option[String] = None
  ): software.amazon.awscdk.services.glue.CfnMLTransform.GlueTablesProperty =
    (new software.amazon.awscdk.services.glue.CfnMLTransform.GlueTablesProperty.Builder)
      .databaseName(databaseName)
      .tableName(tableName)
      .connectionName(connectionName.orNull)
      .catalogId(catalogId.orNull)
      .build()
}
