package io.burkard.cdk.services.glue

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PhysicalConnectionRequirementsProperty {

  def apply(
    subnetId: Option[String] = None,
    availabilityZone: Option[String] = None,
    securityGroupIdList: Option[List[String]] = None
  ): software.amazon.awscdk.services.glue.CfnConnection.PhysicalConnectionRequirementsProperty =
    (new software.amazon.awscdk.services.glue.CfnConnection.PhysicalConnectionRequirementsProperty.Builder)
      .subnetId(subnetId.orNull)
      .availabilityZone(availabilityZone.orNull)
      .securityGroupIdList(securityGroupIdList.map(_.asJava).orNull)
      .build()
}
