package io.burkard.cdk.services.glue

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPartition {

  def apply(
    internalResourceId: String,
    databaseName: String,
    tableName: String,
    partitionInput: software.amazon.awscdk.services.glue.CfnPartition.PartitionInputProperty,
    catalogId: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.glue.CfnPartition =
    software.amazon.awscdk.services.glue.CfnPartition.Builder
      .create(stackCtx, internalResourceId)
      .databaseName(databaseName)
      .tableName(tableName)
      .partitionInput(partitionInput)
      .catalogId(catalogId)
      .build()
}
