package io.burkard.cdk.services.gamelift

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RuntimeConfigurationProperty {

  def apply(
    gameSessionActivationTimeoutSeconds: Option[Number] = None,
    maxConcurrentGameSessionActivations: Option[Number] = None,
    serverProcesses: Option[List[_]] = None
  ): software.amazon.awscdk.services.gamelift.CfnFleet.RuntimeConfigurationProperty =
    (new software.amazon.awscdk.services.gamelift.CfnFleet.RuntimeConfigurationProperty.Builder)
      .gameSessionActivationTimeoutSeconds(gameSessionActivationTimeoutSeconds.orNull)
      .maxConcurrentGameSessionActivations(maxConcurrentGameSessionActivations.orNull)
      .serverProcesses(serverProcesses.map(_.asJava).orNull)
      .build()
}
