package io.burkard.cdk.services.frauddetector

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVariableProps {

  def apply(
    name: Option[String] = None,
    variableType: Option[String] = None,
    dataSource: Option[String] = None,
    dataType: Option[String] = None,
    defaultValue: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.frauddetector.CfnVariableProps =
    (new software.amazon.awscdk.services.frauddetector.CfnVariableProps.Builder)
      .name(name.orNull)
      .variableType(variableType.orNull)
      .dataSource(dataSource.orNull)
      .dataType(dataType.orNull)
      .defaultValue(defaultValue.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
