package io.burkard.cdk.services.eventschemas

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRegistryProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.services.eventschemas.CfnRegistry.TagsEntryProperty]] = None,
    description: Option[String] = None,
    registryName: Option[String] = None
  ): software.amazon.awscdk.services.eventschemas.CfnRegistryProps =
    (new software.amazon.awscdk.services.eventschemas.CfnRegistryProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .registryName(registryName.orNull)
      .build()
}
