package io.burkard.cdk.services.eventschemas

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRegistryPolicyProps {

  def apply(
    policy: AnyRef,
    registryName: String,
    revisionId: Option[String] = None
  ): software.amazon.awscdk.services.eventschemas.CfnRegistryPolicyProps =
    (new software.amazon.awscdk.services.eventschemas.CfnRegistryPolicyProps.Builder)
      .policy(policy)
      .registryName(registryName)
      .revisionId(revisionId.orNull)
      .build()
}
