package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LambdaFunction {

  def apply(
    handler: software.amazon.awscdk.services.lambda.IFunction,
    event: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.events.targets.LambdaFunction =
    software.amazon.awscdk.services.events.targets.LambdaFunction.Builder
      .create(handler)
      .event(event.orNull)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
