package io.burkard.cdk.services.events

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RuleTargetInputProperties {

  def apply(
    input: Option[String] = None,
    inputTemplate: Option[String] = None,
    inputPathsMap: Option[Map[String, String]] = None,
    inputPath: Option[String] = None
  ): software.amazon.awscdk.services.events.RuleTargetInputProperties =
    (new software.amazon.awscdk.services.events.RuleTargetInputProperties.Builder)
      .input(input.orNull)
      .inputTemplate(inputTemplate.orNull)
      .inputPathsMap(inputPathsMap.map(_.asJava).orNull)
      .inputPath(inputPath.orNull)
      .build()
}
