package io.burkard.cdk.services.emr

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InstanceGroupConfigProperty {

  def apply(
    instanceType: String,
    instanceCount: Number,
    ebsConfiguration: Option[software.amazon.awscdk.services.emr.CfnCluster.EbsConfigurationProperty] = None,
    name: Option[String] = None,
    market: Option[String] = None,
    customAmiId: Option[String] = None,
    bidPrice: Option[String] = None,
    autoScalingPolicy: Option[software.amazon.awscdk.services.emr.CfnCluster.AutoScalingPolicyProperty] = None,
    configurations: Option[List[_]] = None
  ): software.amazon.awscdk.services.emr.CfnCluster.InstanceGroupConfigProperty =
    (new software.amazon.awscdk.services.emr.CfnCluster.InstanceGroupConfigProperty.Builder)
      .instanceType(instanceType)
      .instanceCount(instanceCount)
      .ebsConfiguration(ebsConfiguration.orNull)
      .name(name.orNull)
      .market(market.orNull)
      .customAmiId(customAmiId.orNull)
      .bidPrice(bidPrice.orNull)
      .autoScalingPolicy(autoScalingPolicy.orNull)
      .configurations(configurations.map(_.asJava).orNull)
      .build()
}
