package io.burkard.cdk.services.emr

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HadoopJarStepConfigProperty {

  def apply(
    jar: String,
    args: Option[List[String]] = None,
    mainClass: Option[String] = None,
    stepProperties: Option[List[_]] = None
  ): software.amazon.awscdk.services.emr.CfnStep.HadoopJarStepConfigProperty =
    (new software.amazon.awscdk.services.emr.CfnStep.HadoopJarStepConfigProperty.Builder)
      .jar(jar)
      .args(args.map(_.asJava).orNull)
      .mainClass(mainClass.orNull)
      .stepProperties(stepProperties.map(_.asJava).orNull)
      .build()
}
