package io.burkard.cdk.services.emr

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStudio {

  def apply(
    internalResourceId: String,
    authMode: String,
    subnetIds: List[String],
    name: String,
    serviceRole: String,
    vpcId: String,
    workspaceSecurityGroupId: String,
    defaultS3Location: String,
    engineSecurityGroupId: String,
    idpAuthUrl: Option[String] = None,
    userRole: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    idpRelayStateParameterName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.emr.CfnStudio =
    software.amazon.awscdk.services.emr.CfnStudio.Builder
      .create(stackCtx, internalResourceId)
      .authMode(authMode)
      .subnetIds(subnetIds.asJava)
      .name(name)
      .serviceRole(serviceRole)
      .vpcId(vpcId)
      .workspaceSecurityGroupId(workspaceSecurityGroupId)
      .defaultS3Location(defaultS3Location)
      .engineSecurityGroupId(engineSecurityGroupId)
      .idpAuthUrl(idpAuthUrl.orNull)
      .userRole(userRole.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .idpRelayStateParameterName(idpRelayStateParameterName.orNull)
      .build()
}
