package io.burkard.cdk.services.elasticloadbalancing

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HealthCheckProperty {

  def apply(
    healthyThreshold: String,
    unhealthyThreshold: String,
    interval: String,
    target: String,
    timeout: String
  ): software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty =
    (new software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty.Builder)
      .healthyThreshold(healthyThreshold)
      .unhealthyThreshold(unhealthyThreshold)
      .interval(interval)
      .target(target)
      .timeout(timeout)
      .build()
}
