package io.burkard.cdk.services.elasticbeanstalk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ConfigurationOptionSettingProperty {

  def apply(
    optionName: String,
    namespace: String,
    value: Option[String] = None,
    resourceName: Option[String] = None
  ): software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty =
    (new software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Builder)
      .optionName(optionName)
      .namespace(namespace)
      .value(value.orNull)
      .resourceName(resourceName.orNull)
      .build()
}
