package io.burkard.cdk.services.elasticache

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReshardingConfigurationProperty {

  def apply(
    nodeGroupId: Option[String] = None,
    preferredAvailabilityZones: Option[List[String]] = None
  ): software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.ReshardingConfigurationProperty =
    (new software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.ReshardingConfigurationProperty.Builder)
      .nodeGroupId(nodeGroupId.orNull)
      .preferredAvailabilityZones(preferredAvailabilityZones.map(_.asJava).orNull)
      .build()
}
