package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AlbControllerProps {

  def apply(
    cluster: software.amazon.awscdk.services.eks.Cluster,
    version: Option[software.amazon.awscdk.services.eks.AlbControllerVersion] = None,
    policy: Option[AnyRef] = None,
    repository: Option[String] = None
  ): software.amazon.awscdk.services.eks.AlbControllerProps =
    (new software.amazon.awscdk.services.eks.AlbControllerProps.Builder)
      .cluster(cluster)
      .version(version.orNull)
      .policy(policy.orNull)
      .repository(repository.orNull)
      .build()
}
