package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AlbControllerOptions {

  def apply(
    version: software.amazon.awscdk.services.eks.AlbControllerVersion,
    policy: Option[AnyRef] = None,
    repository: Option[String] = None
  ): software.amazon.awscdk.services.eks.AlbControllerOptions =
    (new software.amazon.awscdk.services.eks.AlbControllerOptions.Builder)
      .version(version)
      .policy(policy.orNull)
      .repository(repository.orNull)
      .build()
}
